require( "scripts/style.lua" );


IntroFont = {
  standardFont,
  22,
  BorderColor
};

GoalFont = {
  standardFont,
  22,
  BorderColor
};

ExpertFont = {
  standardFont,
  22,
  BorderColor
};

IntroUserNameFont = {
  standardFont,
  14,
  BorderColor
};

FloIntroFont = {
  standardFont,
  16,
  BorderColor
};

MPWaitingFont = {
  standardFont,
  18,
  BorderColor
};

ChatInfoFont = {
  standardFont,
  16,
  BorderColor
};

MPIntroTitleFont = {
  standardFont,
  40,
  BorderColor
};

MPIntroTitle2Font = {
  standardFont,
  22,
  BorderColor
};

MPIntroDescripFont = {
  standardFont,
  20,
  BorderColor
};

MPTutorialIntroFont = {
  standardFont,
  30,
  BorderColor
};



local showChatWindow = MultiPlayerGame(false);
--uncomment the following to make practice mode behave like
--normal mode and show the chat window
--showChatWindow = true;

allowDefaultPlay = not showChatWindow;

if (showChatWindow) then
	backgroundimage="multi/mp_level_intro_chat";
	backgroundmask="";
else
	backgroundimage="backgrounds/levelintro";
	backgroundmask="";
end


function MakeFloWindows()
	myName = '#'..GetUserName(false);
	yourName = '#'..GetUserName(true);
	floIntro = '#'..GetString('mpflointro', GetUserName(false), GetUserName(true));

	if (showChatWindow) then
		flo1x = 110;
		flo1y = 200;
		flo2x = 525;
		flo2y = flo1y;
		flointrox = kCenter;
		flointroy = flo1y-100;
	else
		flo1x = 132;
		flo1y = 400;
		flo2x = flo1x+280;
		flo2y = flo1y;
		flointrox = flo1x+65;
		flointroy = flo1y-80;
	end
	if (MultiPlayerGame(true)) then
		return Group {
			FloWindow
			{
				x = flo1x,
				y = flo1y,
				frame = 2
			};
			AutoFitText
			{
				x = flo1x-85, 
				y = flo1y+60,
				w = 150,
				h= 40,
				font = IntroUserNameFont,
				flags = kHAlignCenter + kVAlignTop,
				label = myName;
				
			};
			
			
			FloWindow
			{
				x = flo2x,
				y = flo2y,
				frame = 2,
				opponent = true
			};
			
			AutoFitText
			{
				x = flo2x-85, 
				y = flo2y+60,
				w = 150,
				h= 40,
				font = IntroUserNameFont,
				flags = kHAlignCenter + kVAlignTop,
				label = yourName;
				
			};
			
			Text
			{
				x = flointrox, 
				y = flointroy,
				w = 160,
				h= 150,
				font = FloIntroFont,
				flags = kHAlignCenter + kVAlignCenter,
				label = floIntro;
				
			};
		}
	else
		return Group {
		
		}
	end
	
end

function MakeMPText()
	
	if (IsMPTutorialLevel()) then
		return Group {
			Text
			{
				x = 60, w = kMax-60,
				y = 100, h = 300,
				font=MPTutorialIntroFont,
				label='mptutorial_intro',
				flags = kHAlignCenter + kVAlignTop
			};
		}
	else
		if (GetMultiplayerMode()==0) then
			titleLabel = 'mpintro_team_1';
			title2Label = 'mpintro_team_2';
		else
			titleLabel = 'mpintro_showdown_1';
			title2Label = 'mpintro_showdown_2';
		end
		if(GetTableType() == 1) then
			if (GetMyPlayerNum() == 0) then
				descripLabel = '#'..GetString('mpintro_assigned', GetString('mpintro_player1_color'));
			else
				descripLabel = '#'..GetString('mpintro_assigned', GetString('mpintro_player2_color'));
			end
		else
			descripLabel = '#'..GetString('mpintro_open');
		end
		
		if (showChatWindow) then
			imwaiting = '#'..GetString("mp_waitingforyou", GetUserName(true));
			yourewaiting = '#'..GetString("mp_waitingforme", GetUserName(true));
			
			return Group {
				
				Text
				{
					x = 0, w = kMax,
					y = 5, h = 100,
					label=titleLabel,
					font=MPIntroTitleFont,
					flags = kHAlignCenter + kVAlignTop
				};
				
				Text
				{
					x = 0, w = kMax,
					y = 55, h = 100,
					label=title2Label,
					font=MPIntroTitle2Font,
					flags = kHAlignCenter + kVAlignTop
				};
				
				Text
				{
					x = 100, w = kMax-100,
					y = 100, h = 100,
					label=descripLabel,
					font=MPIntroDescripFont,
					flags = kHAlignCenter + kVAlignTop
				};
				
				
				
				Text
				{
					x = 0, 
					y = 235,
					w = kMax,
					h= 20,
					name = 'mpiamwaiting',
					font = MPWaitingFont,
					flags = kHAlignCenter + kVAlignTop,
					label = imwaiting;
				};
				
				Text
				{
					x = 0, 
					y = 235,
					w = kMax,
					h= 20,
					name = 'mpyouarewaiting',
					font = MPWaitingFont,
					flags = kHAlignCenter + kVAlignTop,
					label = yourewaiting;
					
				};
				
			}
		else
			return Group {
				Text
				{
					x = 60, w = kMax-60,
					y = 40, h = 100,
					label=titleLabel,
					font=MPIntroTitleFont,
					flags = kHAlignCenter + kVAlignTop
				};
				
				Text
				{
					x = 60, w = kMax-60,
					y = 160, h = 100,
					label=title2Label,
					font=MPIntroTitle2Font,
					flags = kHAlignCenter + kVAlignTop
				};
				
				Text
				{
					x = 100, w = kMax-100,
					y = 240, h = 100,
					label=descripLabel,
					font=MPIntroDescripFont,
					flags = kHAlignCenter + kVAlignTop
				};
			}
		end
	end
	
end

function MakeMPQuitButton()
	if (showChatWindow) then
		return Group {
			SetStyle(SolidButtonStyle);
			Button
			{
				x=700,
				y=570,
				name="introquit",
				label='quit',
				command=
					function()
						result = DisplayDialog { 
								"scripts/yesno.lua", 
								body ="quitconfirm",
								title = "",
						};
						if (result=='yes') then
							
							QuitGame(true);
							CloseAllWindows();
						end
					end
				
			}
		}
		
	else
		return Group {
		
		}
	end
end


function MakeEmbeddedIntroChatWindow(showChatWindow, chatInfoText)
	if (showChatWindow) then
		

		return Group {
			--MakeIGChatWindow();
			SetStyle(SmallButtonStyle);
			AutoFitText
			{
				x = 0, w=kMax;
				y = 330, h = 50;
				flags = kHAlignCenter + kVAlignTop,
				label = chatInfoText,
				font = ChatInfoFont
			};
			SetStyle(ChatScrollArrowStyle);
			Button
			{
				x = 577, y = 335,
				command =
					function()
						ChatArrow(false);
					end
			};
			
			Button
			{
				x = 577, y = 457,
				vflip = true,
				command =
					function()
						ChatArrow(true);
					end
			};
			SetStyle(ChatScrollStyle);
			ScrolledWindow
			{
				x=35,y=354,w=562,h=104,
				name='chatscroller',
				Text
				{
					x = 0, y = 0, w = kMax-25, h = kMax,
					name="embeddedchatoutput",
					font=ChatFont,
					label='',
					flags=kHAlignLeft+ kVAlignTop,
					padding=0
				},
			},
			SetStyle(DefaultStyle);
			TextEdit 
			{
				name="embeddedchatentry",
				label=GetString("mpentertexthere"),
				font=ChatFont,
				length=100,
				clearinitial = true,
				flags=kHAlignLeft+ kVAlignCenter,
				x=35,y=461,w=455,h=27
			},
			Text
			{
				x= 0,
				y = 520,
				w = kMax,
				h = kMax,
				font = ChatTOSFont,
				flags = kHAlignCenter + kVAlignTop,
				label = 'mp_chat_tos'
			},
			SetStyle(SmallestButtonStyle);
			Button
			{
				x = 492,
				y = 461,
				label = 'mpsendchat',
				name = 'chatsend',
				default = true,
				command = 
					function()
						ChatSendButton();
					end
			};
		}
	else
		return Group {
		
		}
	end
end   


if (showChatWindow) then
	introx=40;
	introy=30;
	introw=kMax-40;
	introh=402;
	buttonx=kCenter;
	buttony=260;
else
	introx=30;
	introy=120;
	introw=kMax-30;
	introh=402;
	buttonx=kCenter;
	buttony=-83;
end

chatInfoText = '#'..GetString("mp_youcanchat", GetUserName(false), GetUserName(true));			

MakeDialog
{
	LevelIntro
	{
		x=0,
		y=0,
		w=800,
		h=600,
		name="levelintrowin",
		
		Window
		{
			name="introbackground",
			x=0,
			y=0,
			w=800,
			h=600,
			Bitmap
			{
			
				image=backgroundimage,
				mask=backgroundmask,
				x=kCenter,
				y=kCenter,	
				
				MakeFloWindows();
				MakeMPText();
				
				
				SetStyle(StandardButtonStyle);
				Button
				{
					x=buttonx,
					y=buttony,
					name="letsplay",
					label="letsplay",
					default = allowDefaultPlay
				},
				SetStyle(DefaultStyle);
			
				MakeEmbeddedIntroChatWindow(showChatWindow, chatInfoText);	
			},
			
		};
		
	};
	
	MakeMPQuitButton();
		
	
}


EnableWindow('mpiamwaiting', false);
EnableWindow('mpyouarewaiting', false);
if (showChatWindow) then
	AdoptChatWindow();
	SetEmbeddedChatMode(true, 7);
end